menuOptions() // 12 options max per menu or submenu since i didnt add infinite scroll
{
    if(level.status == 1)
    {
        self addMenu( "main", "Menu Base" );
        self addOpt( "Account", ::newMenu, "Account" );
        self addOpt( "Infections", ::newMenu, "Infections" );
        self addOpt( "Visions", ::newMenu, "Visions" );
        self addOpt( "VIP", ::newMenu, "VIP" );
        
        if(level.status >= 2)
        {
            self addOpt( "Admin", ::newMenu, "Admin" );
            self addOpt( "Clients Menu", ::newMenu, "clients" );
        }
    }

    // Account Menu
    #region
        
        self addMenu("Account", "Account");
        self addOpt( "Unlock All", ::UnlockAll, self, true );
        self addOpt( "Level 1", ::Level1, self );
        self addOpt( "Level 70", ::Level70, self );  
        self addOpt( "Prestige Menu", ::newMenu, "Prestige Menu" );
        self addOpt( "Accolades Menu", ::newMenu, "Accolades Menu" );
        self addOpt( "Stats Menu", ::newMenu, "Stats Menu" );
        self addOpt( "Clantag Menu", ::newMenu, "Clantag Menu" );
        self addOpt( "Class Names", ::newMenu, "Class Names" );
        //
        self addMenu( "Prestige Menu", "Prestige Menu" );
        self addOpt( "Prestige 0", ::Prestige0, self );
        self addOpt( "Prestige 1", ::Prestige1, self );
        self addOpt( "Prestige 2", ::Prestige2, self );
        self addOpt( "Prestige 3", ::Prestige3, self );
        self addOpt( "Prestige 4", ::Prestige4, self );
        self addOpt( "Prestige 5", ::Prestige5, self );
        self addOpt( "Prestige 6", ::Prestige6, self );
        self addOpt( "Prestige 7", ::Prestige7, self );
        self addOpt( "Prestige 8", ::Prestige8, self );
        self addOpt( "Prestige 9", ::Prestige9, self );
        self addOpt( "Prestige 10", ::Prestige10, self );
        self addOpt( "Prestige 11", ::Prestige11, self );
        //
        self addMenu( "Accolades Menu", "Accolades Menu" );
        presets = [ "Max","Insane","High","Medium","Legit","Reset" ];
        for(a=0;a<presets.size;a++)
            self addOpt( presets[a], ::PreSetAccolades, presets[a], self );
        //
        self addMenu( "Stats Menu", "Stats Menu" );
        self addOpt( "Max Stats", ::MaxStats );
        self addOpt( "Insane Stats", ::InsaneStats );
        self addOpt( "Moderate Stats", ::ModerateStats );
        self addOpt( "Legit Stats", ::LegitStats );
        self addOpt( "Reset Stats", ::ResetStats );
        //
        self addMenu( "Clantag Menu", "Clantag Menu" );
        self addOpt( "{@@}", ::PresetClantag, "{@@}" );
        self addOpt( "{<3}", ::PresetClantag, "{<3}" );
        self addOpt( "{IW}", ::PresetClantag, "{IW}" );
        self addOpt( "@Xe", ::PresetClantag, "@Xe" );
        self addOpt( "@RGH", ::PresetClantag, "@RGH" );
        self addOpt( "@Mox", ::PresetClantag, "@Mox" );
        self addOpt( "JT@G", ::PresetClantag, "JT@G" );
        self addOpt( "IW", ::PresetClantag, "IW" );
        self addOpt( "FUCK", ::PresetClantag, "FUCK" );
        self addOpt( "DICK", ::PresetClantag, "DICK" );
        self addOpt( "COCK", ::PresetClantag, "COCK" );
        self addOpt( "TITS", ::PresetClantag, "TITS" );
        //
        self addMenu( "Class Names", "Class Names" );
        self addOpt( "Moxah Classes", ::MoxahClasses, self );
        self addOpt( "Software Classes", ::SoftwareClasses, self );
        self addOpt( "TU6 Classes", ::TU6Classes, self );
        self addOpt( "Sub Classes", ::SubClasses, self );
        self addOpt( "Button Classes", ::ButtonClasses, self );
        self addOpt( "Button 2 Classes", ::Button2Classes, self );
        self addOpt( "Button 3 Classes", ::Button3Classes, self );
    #endregion
    
    // Infections
    #region
        
        self addMenu( "Infections", "Infections" );
        self addOpt( "Knockback", ::KnockbackInfection );
        self addOpt( "Backspeed", ::BackspeedInfection );
        self addOpt( "Promod", ::WeaponProMod );
        self addOpt( "Raised Gun", ::RaisedGunInfection );
        self addOpt( "Left Side Gun", ::LeftSideGunInfection );
        self addOpt( "UI Showlist", ::ShowList );
        self addOpt( "Upgraded Perks", ::UpgradedPerks );
        self addOpt( "Big Compass Size", ::BigCompassSize );
        self addOpt( "Hear Everyone", ::HearEveryone );
        self addOpt( "Ping Bars", ::PingBars );
        self addOpt( "GT/Scoreboard Colors", ::GTColor );
        self addOpt( "Crazy Javelin", ::CrazyJavelin );
        self addOpt( "Crazy Infections", ::CrazyInfections );
        
    #endregion

    // Visions
    #region
        
        self addMenu( "Visions", "Visions" );
        self addOpt( "Chrome Vision", ::ChromeVision, self );
        self addOpt( "Cartoon Vision", ::CartoonVision, self );
        self addOpt( "Leet Vision", ::LeetVision );
        self addOpt( "Rainbow Vision", ::RainbowVision );
        self addOpt( "Purple Vision", ::PurpleVision );
        self addOpt( "Water Sheet Vision", ::WaterSheetVision );
        self addOpt( "PC Vision", ::PCVision );
        self addOpt( "Colorful Box", ::ColorfulBox );
        self addOpt( "Color Map", ::ColorMap );
        self addOpt( "Contrast Vision", ::ContrastVision );
        self addOpt( "Orange Box", ::OrangeBox );
    
    #endregion

    //VIP
    #region
        
        self addMenu( "VIP", "VIP" );
        self addOpt( "Killstreak Menu", ::newMenu, "Killstreak Menu" );
        self addOpt( "Projectiles Menu", ::newMenu, "Projectiles Menu" );
        self addOpt( "God Mode", ::Godmode );
        self addOpt( "UFO Mode", ::UFOMode );
        self addOpt( "Promod", ::Promod );
        self addOpt( "Unlimited Ammo", ::InfiniteAmmo );
        self addOpt( "Give All Perks", ::GiveAllPerks );
        self addOpt( "Rain Money", ::createMoney, self );
        self addOpt( "Mortar Strike", ::MortarStrike );
        self addOpt( "Human Centipede", ::HumanCentipede );
        self addOpt( "Walking AC130", ::ToggleWalkAC );
        self addOpt( "DeathMachine", ::Dmac );
        self addOpt( "Care Package Gun", ::CarePackageGun );
        //
        self addMenu( "Projectiles Menu", "Projectiles Menu" );
        self addOpt( "Default", ::EndProjectile  );
        self addOpt( "RPG", ::Projectile, "rpg"  );
        self addOpt( "Thumper", ::Projectile, "m79" );
        self addOpt( "Stinger", ::Projectile, "stinger" );
        self addOpt( "Javelin", ::Projectile, "javelin" );
        self addOpt( "AT4-HS", ::Projectile, "at4" );
        self addOpt( "Remote Missle Bullets", ::Projectile, "remotemissile_projectile" );
        self addOpt( "Harrier Bullets", ::Projectile, "harrier_20mm" );
        self addOpt( "AC130 25mm", ::Projectile, "ac130_25mm" );
        self addOpt( "AC130 40mm", ::Projectile, "ac130_40mm" );
        self addOpt( "AC130 105mm", ::Projectile, "ac130_105mm" );
        //
        self addMenu( "Killstreak Menu", "Killstreak Menu" );
        self addOpt( "UAV", ::GivePlayerKillstreak, "uav" );
        self addOpt( "Care-Package", ::GivePlayerKillstreak, "airdrop" );
        self addOpt( "Counter-UAV", ::GivePlayerKillstreak, "counter_uav" );
        self addOpt( "Sentry Gun", ::GivePlayerKillstreak, "airdrop_sentry_minigun" );
        self addOpt( "Predator Missle", ::GivePlayerKillstreak, "predator_missile" );
        self addOpt( "Precision", ::GivePlayerKillstreak, "precision_airstrike" );
        self addOpt( "Harrier", ::GivePlayerKillstreak, "harrier_airstrike" );
        self addOpt( "Attack Heli", ::GivePlayerKillstreak, "helicopter" );
        self addOpt( "Emergency Airdrop", ::GivePlayerKillstreak, "airdrop_mega" );
        self addOpt( "Pavelow", ::GivePlayerKillstreak, "helicopter_flares" );
        self addOpt( "Page 2 >>", ::newMenu, "Page 2 >>" );
        //
        self addMenu( "Page 2 >>", "Page 2 >>" );
        self addOpt( "Stealth Bomber", ::GivePlayerKillstreak, "stealth_airstrike" );
        self addOpt( "Chopper Gunner", ::GivePlayerKillstreak, "helicopter_minigun" );
        self addOpt( "AC130", ::GivePlayerKillstreak, "ac130" );
        self addOpt( "EMP", ::GivePlayerKillstreak, "emp" );
        self addOpt( "Nuke", ::GivePlayerKillstreak, "nuke" );
        
    #endregion
   
    // Admin
    #region
        
        self addMenu( "Admin", "Admin" );
        self addOpt( "Bots Menu", ::newMenu, "Bots Menu" );
        self addOpt( "Super Jump", ::SuperJump );
        self addOpt( "Super Speed", ::SuperSpeed );
        self addOpt( "Low Gravity", ::LowGravity );
        self addOpt( "Zero Gravity", ::ZeroGravity );
        self addOpt( "Friction", ::Friction );
        self addOpt( "Slow Timescale", ::SlowMotion );
        self addOpt( "Fast Timescale", ::Chipmunk );
        self addOpt( "Unlimited Game", ::UnlimitedGame );
        self addOpt( "Online Game", ::OnlineGame );
        self addOpt( "18 Man Teams", ::MaxTeamCount );
        self addOpt( "Fast Restart", ::ServerRestart );
        self addOpt( "Page 2 >>", ::newMenu, "Admin 2" );
        //
        self addMenu( "Admin 2", "Admin 2" );
        self addOpt( "Disable Death Barriers", ::DisableDeathBarriers );
        self addOpt( "Floaters", ::ToggleFloaters );
        self addOpt( "No Score Limit", ::ServerSetLobbyScore, 0 );
        self addOpt( "Endgame", ::EndGame );
        self addOpt( "Disco Fog", ::discoFog, true );
        self addOpt( "Disco Sun", ::DiscoSun );
        //
        self addMenu( "Bots Menu", "Bots Menu" );
        self addOpt( "Spawn Enemy Bot", ::AddBot, 1, "enemy" );
        self addOpt( "Spawn Friendly Bot", ::AddBot, 1, "friendly" );
        self addOpt( "Kill Bots", ::KillBots );
        self addOpt( "Kick Bots", ::KickBots );
        self addOpt( "Freeze/Unfreeze Bots", ::FreezeBots );
        self addOpt( "Bots Dont Shoot", ::BotsDontShoot );
        self addOpt( "Bots Reload", ::BotsReload );
        self addOpt( "Bots Crouch", ::BotsCrouch );
        self addOpt( "Bots No Killcam", ::BotsNoKillcam );
        self addOpt( "TP To Me", ::BotsToMe );
        self addOpt( "TP To Crosshair", ::BotsToCrosshairs );
        self addOpt( level.BotsToCrosshairConstant, "Bots To Crosshairs Loop", ::BotsToCrosshairConstant );
        
    #endregion
        
    self clientOptions();
}

clientOptions()
{
    self addmenu( "clients", "Clients Menu" );
    foreach( player in level.players )
    {
        if(!IsDefined( player.access ))
            player.access = level.status[0];
            
        self addopt( "["+ player.access +"^7] " + player getname(), ::newmenu, "client_" + player getentitynumber() );
    }
            
    foreach(player in level.players)
    {
        self addmenu( "client_" + player getentitynumber(), player getname() );
        for(e=0; e < level.status.size -1; e++ )
            self addOpt( "Give " + level.status[e], ::initializeSetup, e, player );
        self addOpt( "Give Level 70", ::Level70, player );
        self addOpt( "Give Prestige 9", ::Prestige9, player );
        self addOpt( "Give Prestige 10", ::Prestige10, player );
        self addOpt( "Give Prestige 11", ::Prestige11, player );
        self addOpt( "Kill Client", ::KillPlayer, player );
        self addOpt( "Kick Client", ::KickPlayer, player );
        self addOpt( "Send To Crosshairs", ::SendToCrossHairs, player );
        self addOpt( "Teleport To Player", ::TPToPlayer, player );
        self addOpt( "Send To Space", ::SendToSky, player );
        self addOpt( "Freeze/Unfreeze Player", ::FreezePlayer, player );
    }
}
    
menuMonitor()
{
    self endon("disconnected");
    self endon("end_menu");

    self thread openMenuText();
    while( true )
    {
        if(!self.menu["isLocked"])
        {
            if(!self.menu["isOpen"])
            {
                if( self meleeButtonPressed() && self adsButtonPressed() )
                {
                    self thread menuOpen();
                    wait .2;
                }               
            }
            else 
            {
                if(self isButtonPressed("+actionslot 1") || self isButtonPressed("+actionslot 2"))
                {
                    if(!self isButtonPressed("+actionslot 1") || !self isButtonPressed("+actionslot 2"))
                    {
                        self.menu[ self getCurrentMenu() + "_cursor" ] += self isButtonPressed("+actionslot 2");
                        self.menu[ self getCurrentMenu() + "_cursor" ] -= self isButtonPressed("+actionslot 1");
                        
                        if(self getCursor() >= self.eMenu.size)
                            self.menu[ self getCurrentMenu() + "_cursor" ] = 0;
                        if(self.menu[ self getCurrentMenu() + "_cursor" ] < 0)
                            self.menu[ self getCurrentMenu() + "_cursor" ] = self.eMenu.size -1; 
                            
                        self updateScrollbar();
                        
                        wait .1;
                    }
                }
                else if( self FragButtonPressed() || self SecondaryOffhandButtonPressed() )
                {
                    self.menu[ "submenu_cursor" ] += self FragButtonPressed();
                    self.menu[ "submenu_cursor" ] -= self SecondaryOffhandButtonPressed();
                    
                    if(self getSubmenuCurs() > getSubmenus().size -1)
                        self setSubmenuCurs( 0 );
                    if(self getSubmenuCurs() < 0)
                        self setSubmenuCurs( getSubmenus().size -1);
                        
                    self thread newMenu( self getSubmenus()[getSubmenuCurs()].p1 );
                    
                    wait .15;
                }
                else if( self useButtonPressed() )
                {
                    menu = self.eMenu[self getCursor()];
                    self thread [[ menu.func ]]( menu.p1, menu.p2, menu.p3, menu.p4, menu.p5);
                    
                    wait .15;
                }
                else if( self meleeButtonPressed() )
                {
                    if( self isInMain() )
                        self menuClose();
                     else
                        self newMenu();
                        
                    wait .15;
                }
            }
        }
        wait .05;
    }
}

openMenuText()
{
    self.menu["Info"]["OMText"] = self createText( "objective", 1.3, "CENTER", "CENTER", 300, 0, 1, 1, "^1Open ^2Mod ^3Menu - [{+speed_throw}] & [{+melee}]\n^1Press [{+melee}] ^2To ^3Close ^4Menu",color,glowColor,isLevel);
}

destroyMenuText()
{
    self.menu["Info"]["OMText"] thread hudFadenDestroy(0, .3);
}

menuOpen()
{
    self endon( "disconnect" );
    
    self.menu["isOpen"] = true;
    
    self destroyMenuText();
    self menuOptions();
    self drawText(); 
    self updateScrollbar();
    
    self thread newMenu( self getSubmenus()[getSubmenuCurs()].p1 );
    //self.menu["OPT"]["Background"] = createRectangle( "CENTER", "CENTER", 0, 0, 1000, 1000, divideColor(0, 0, 0), "white", 5, .8 ); // removed shader and replaced with viewport dva
    self SetClientDvar( "r_blur", "4" );
    self SetClientDvar( "cg_crosshairAlpha", "0" );
    self SetClientDvar( "scr_gameEnded", 1 );
}

menuClose()
{
    self.menu["isOpen"] = false;
    self destroyAll( self.menu["OPT"] );
    wait .01;
    self SetClientDvar( "r_blur", "0" );
    self SetClientDvar( "cg_crosshairAlpha", "1" );
    self openMenuText();
}

drawText()
{
    if(!isDefined(self.menu["OPT"]))
        self.menu["OPT"] = [];
        
    for(e=0;e<4;e++)
    {
        fontscale = 1.1;
        if(e == 1) fontscale = 1.6;
        
        self.menu["OPT"]["TITLE"+e] = self createText("objective", fontscale, "CENTER", "CENTER", -140 + (e*140), -130, 3, 0, "", divideColor(35, 124, 224));    
        self.menu["OPT"]["TITLE"+e] thread hudFade( 1, .2 ); 
    }
    
    self refreshTitle();

    for(e=0;e<15;e++)
    {
        self.menu["OPT"][e] = self createText("objective", 1.1, "CENTER", "CENTER", 0, -100 + (e*15), 3, 0, "", divideColor(0, 0, 0));
        self.menu["OPT"][e] thread hudFade( 1, .2 );
    }
    
    self setMenuText();    
}

getSubmenus()
{
    if(IsDefined( self.submenus ))
        return self.submenus;
    self.submenus = [];
    
    for(e=0;e<self.eMenu.size;e++)
    {
        if(isDefined(self.eMenu[e].func) && self.eMenu[e].func == ::newMenu)
            self.submenus[self.submenus.size] = self.eMenu[e];
    }
        
    return self.submenus;
}

getSubmenuCurs()
{ return self.menu[ "submenu_cursor" ]; }

setSubmenuCurs( val )
{ self.menu[ "submenu_cursor" ] = val; }

refreshTitle()
{
    for(e=0;e<3;e++)
        self.menu["OPT"]["TITLE"+e] setSafeText(self getSubmenus()[revalueTitles(getSubmenuCurs() + (e - 1), getSubmenus())].opt);
}
    
isInMain()
{
    for(e=0;e<getSubmenus().size;e++)
        if( getSubmenus()[e].p1 == getCurrentMenu() )
            return true;
    return false;
}
 
revalueTitles(value, array)
{
    if(value < 0) 
        return value + array.size;
    if(value >= array.size) 
        return value - array.size;
    
    return value;
}    

updateScrollbar()
{
    curs = self getCursor();
    if(curs >= 15)
        curs = 14;    
        
    self notify("stop_text_effects");  
    wait .05;
    self.menu["OPT"][curs] thread flashElemMonitor( self );  
    self.menu["OPT"][curs] thread flashElem( 1, .5, .13, self );   
}

setMenuText()
{
    ary = 0;
    if(self getCursor() >= 15)
        ary   = self getCursor() - 14;
        
    for(e=0;e<15;e++)
    {
        if(isDefined(self.eMenu[ ary + e ].opt))
            self.menu["OPT"][ ary + e ] setSafeText( self.eMenu[ ary + e ].opt );
        else     
        self.menu["OPT"][ ary + e ] setSafeText( "" );
    }
}
        
flashElem( alpha1, alpha2, time, player )
{
    player endon("stop_text_effects");
    
    //self.color     = (RandomIntRange( 0, 255 ) / 255, RandomIntRange( 0, 255 ) / 255, RandomIntRange( 0, 255 ) / 255);
    self.alpha     = 1;
    self.glowalpha = 1;
    self.glowcolor = (RandomIntRange( 0, 255 ) / 255, RandomIntRange( 0, 255 ) / 255, RandomIntRange( 0, 255 ) / 255);
    self.fontScale = 1.5;
    
    while(isDefined(self))
    {
        self hudFade(alpha1, time);
        wait time;
        self hudFade(alpha2, time);
        wait time; 
    }
}

flashElemMonitor( player )
{
    player waittill("stop_text_effects");  
    self.alpha     = 1;
    self.glowalpha = 0;
    self changefontscaleovertime( .1 );
    self.fontScale = 1.1;
}